/*
 * Decompiled with CFR 0.152.
 */
package ai.cequence.integrations.edge.common;

import ai.cequence.integrations.edge.common.CequenceConnector;
import ai.cequence.integrations.edge.common.Connection;
import ai.cequence.integrations.edge.common.Metadata;
import ai.cequence.integrations.edge.common.Request;
import ai.cequence.integrations.edge.common.Response;
import ai.cequence.integrations.edge.common.SourceInfo;
import com.google.gson.annotations.SerializedName;
import java.util.logging.Logger;

public class ApiTransaction {
    private static final String CQ_API_TXN_VERSION = "1.0";
    @SerializedName(value="transaction-id")
    String transactionId;
    String timestamp;
    String version = "1.0";
    Request request;
    Response response;
    Metadata metadata;
    long txnLatency = 0L;
    long txnCreateTime = System.nanoTime();

    boolean isValid() {
        Logger logger = CequenceConnector.getLogger();
        if (this.transactionId == null || this.transactionId.isEmpty()) {
            logger.info("isValidTxn: id invalid");
            return false;
        }
        if (this.timestamp == null || this.timestamp.isEmpty()) {
            logger.info("isValidTxn: timestamp invalid. txn id: " + this.transactionId);
            return false;
        }
        if (this.version == null || this.version.isEmpty()) {
            logger.info("isValidTxn: txn version invalid. txn id: " + this.transactionId);
            return false;
        }
        if (this.request == null || this.request.headers == null || this.request.body == null || this.request.connection == null) {
            logger.info("isValidTxn: request data invalid. txn id: " + this.transactionId);
            return false;
        }
        Connection conn = this.request.connection;
        if (conn.connectionIP == null || conn.connectionIP.isEmpty() || conn.serverIP == null || conn.serverIP.isEmpty()) {
            logger.info("isValidTxn: request connection data invalid. txn id: " + this.transactionId);
            return false;
        }
        if (this.response == null || this.response.headers == null || this.response.body == null || this.response.statusCode == null || this.response.statusCode.isEmpty()) {
            logger.info("isValidTxn: response data invalid. txn id: " + this.transactionId);
            return false;
        }
        if (this.metadata == null || this.metadata.source == null) {
            logger.info("isValidTxn: metadata invalid. txn id: " + this.transactionId);
            return false;
        }
        SourceInfo src = this.metadata.source;
        if (src.type == null || src.type.isEmpty() || src.instanceId == null || src.instanceId.isEmpty()) {
            logger.info("isValidTxn: required data in metadata.source_info missing. txn id: " + this.transactionId);
            return false;
        }
        return true;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public long getTxnLatency() {
        return this.txnLatency;
    }

    public void setTxnLatency(long txnLatency) {
        this.txnLatency = txnLatency;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }
}

