/*
 * Decompiled with CFR 0.152.
 */
package ai.cequence.integrations.edge.common;

import ai.cequence.integrations.edge.common.ApiTransaction;
import ai.cequence.integrations.edge.common.ConnectorConfig;
import ai.cequence.integrations.edge.common.ConnectorStats;
import ai.cequence.integrations.edge.common.CqHttpClient;
import ai.cequence.integrations.edge.common.MQAddRValue;
import ai.cequence.integrations.edge.common.MultiQueue;
import ai.cequence.integrations.edge.common.TimerService;
import ai.cequence.integrations.edge.common.Token;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CequenceConnector {
    private static String loggerUuidStr = UUID.randomUUID().toString();
    private static Logger logger = Logger.getLogger("logger.integrations.edge.common." + loggerUuidStr);
    static String uriAuth = null;
    static String clientId = null;
    static String clientSecret = null;
    static String uriTxn = null;
    static int defaultUapMaxSize = 10000000;
    static int defaultBatchInterval = 5000;
    static int defaultBatchCount = 100;
    static int defaultQueueSize = 100;
    static int defaultMaxQueues = 200;
    private static final String defaultPropsFileName = "config.properties";
    private static Properties defaultProps = new Properties();
    static String defaultAuthType = "oauth2";
    static String defaultTxnEndpointType = "uap";
    int queueSize = defaultQueueSize;
    int maxQueues = defaultMaxQueues;
    int uapMaxSize = defaultUapMaxSize;
    int batchInterval = defaultBatchInterval;
    long currGatewayTimeInSec = 0L;
    long getTokenCapturedTimeInSec = 0L;
    boolean serverCertValidationDisabled = false;
    boolean uapSendDisabled = false;
    boolean uapAuthDisabled = false;
    boolean logUapTxnEnabled = false;
    static Boolean connectorReady = false;
    static long txnTx = 0L;
    static long txnRx = 0L;
    static long txnAvgTxSize = 0L;
    static long txnTxBatches = 0L;
    static long txnDiscarded = 0L;
    static String defaultLibVersion;
    static String libVersion;
    static String pluginVersion;
    static Token authToken;
    static CqHttpClient txnClient;
    static CqHttpClient tokenClient;
    private ConnectorConfig config;
    private static MultiQueue<ApiTransaction> mq;
    private static TimerService sTimer;

    static Logger getLogger() {
        return logger;
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    protected CequenceConnector() {
    }

    void setLogger(Logger newLogger) {
        if (newLogger != null) {
            logger = newLogger;
        }
    }

    public static CequenceConnector getInstance(ConnectorConfig config, Logger pluginLogger) {
        if (config.getAuthTokenUrl() == null || config.getAuthTokenUrl().isEmpty() || config.getTransactionEndpointUrl() == null || config.getTransactionEndpointUrl().isEmpty() || config.getClientId() == null || config.getClientId().isEmpty() || config.getClientSecret() == null || config.getClientSecret().isEmpty()) {
            if (pluginLogger != null) {
                pluginLogger.warning("required config parameters NOT provided");
            }
            return null;
        }
        Level curLevel = null;
        Level effLevel = null;
        Logger curLog = pluginLogger;
        while (curLevel == null) {
            curLevel = curLog.getLevel();
            if (curLevel != null) continue;
            curLog = curLog.getParent();
        }
        effLevel = curLevel;
        curLevel = pluginLogger.getLevel();
        pluginLogger.info("CequenceConnector getInstance: Log levels: current: " + curLevel + " effective: " + effLevel);
        CequenceConnector cq = new CequenceConnector();
        cq.setLogger(pluginLogger);
        pluginLogger.info("Loading library default properties file..");
        CequenceConnector.loadConfigProperties();
        if (config.getLibVersion().isEmpty()) {
            String libVersion = defaultProps.getProperty("version", defaultLibVersion);
            pluginLogger.info("setting the lib version from properties file.. version: " + libVersion);
            config.setLibVersion(libVersion);
        }
        cq.setConfig(config);
        return cq;
    }

    static Boolean loadConfigProperties() {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(defaultPropsFileName);
        try {
            logger.info("Loading Config Properties using Thread Context loader..");
            defaultProps.load(inputStream);
            logger.info("Loaded Config Properties: " + defaultProps);
            return true;
        }
        catch (IOException e) {
            logger.warning("Failed to load Config Properties using Thread Context loader!! Error: " + e.getMessage());
            ClassLoader clCurClass = CequenceConnector.class.getClassLoader();
            URL defResUrl = clCurClass.getResource(defaultPropsFileName);
            try {
                logger.info("Loading Config Properties using Class loader..");
                defaultProps.load(defResUrl.openStream());
                logger.info("Loaded Config Properties: " + defaultProps);
                return true;
            }
            catch (IOException e2) {
                logger.warning("Failed to load Config Properties using Class loader!! Error: " + e2.getMessage());
                return false;
            }
        }
    }

    private static ConnectorConfig makeConfigFromProps(Properties props) {
        ConnectorConfig config = new ConnectorConfig();
        String gwName = props.getProperty("gatewayName", "No-Gateway-Name");
        String authUrl = props.getProperty("authUrl");
        String txnUrl = props.getProperty("transactionEndpointUrl");
        String clientId = props.getProperty("clientId");
        String clientSecret = props.getProperty("clientSecret");
        if (gwName != null && !gwName.isEmpty()) {
            config.setSrcGwName(gwName);
        }
        if (authUrl != null && !authUrl.isEmpty()) {
            config.setAuthTokenUrl(authUrl);
        }
        if (txnUrl != null && !txnUrl.isEmpty()) {
            config.setTransactionEndpointUrl(txnUrl);
        }
        if (clientId != null && !clientId.isEmpty()) {
            config.setClientId(clientId);
        }
        if (clientSecret != null && !clientSecret.isEmpty()) {
            config.setClientSecret(clientSecret);
        }
        int uapMaxSize = Integer.parseInt(props.getProperty("uapMaxSize", String.valueOf(defaultUapMaxSize)));
        int batchSize = Integer.parseInt(props.getProperty("batchSize", String.valueOf(defaultQueueSize)));
        int maxBatches = Integer.parseInt(props.getProperty("maxBatches", String.valueOf(defaultMaxQueues)));
        boolean disableServerCertValidation = Boolean.parseBoolean(props.getProperty("disableServerCertValidation", "false"));
        String authType = props.getProperty("authType", defaultAuthType);
        String txnEndpointType = props.getProperty("transactionEndpointType", defaultTxnEndpointType);
        config.setMaxMessageSize(uapMaxSize);
        config.setBatchSize(batchSize);
        config.setMaxBatches(maxBatches);
        config.setServerCertValidationDisabled(disableServerCertValidation);
        config.setAuthType(authType);
        config.setTransactionEndpointType(txnEndpointType);
        String version = props.getProperty("version", defaultLibVersion);
        config.setLibVersion(version);
        return config;
    }

    static ConnectorConfig loadDefaultPropertiesFile() {
        CequenceConnector.loadConfigProperties();
        return CequenceConnector.makeConfigFromProps(defaultProps);
    }

    public static ConnectorConfig loadConfigPropertiesFile(String filePath) {
        Properties configProps = new Properties();
        try {
            configProps.load(new FileInputStream(filePath));
        }
        catch (IOException io) {
            logger.warning("cannot load properties from: " + filePath + " Error: " + io.getMessage());
            return null;
        }
        return CequenceConnector.makeConfigFromProps(configProps);
    }

    public Boolean setConfig(ConnectorConfig newConfig) {
        String txnEndpointType;
        String authType;
        String cfgAuthUrl = newConfig.getAuthTokenUrl();
        String cfgTxnUrl = newConfig.getTransactionEndpointUrl();
        String cfgClientId = newConfig.getClientId();
        String cfgClientSecret = newConfig.getClientSecret();
        if (cfgAuthUrl == null || cfgAuthUrl.isEmpty() || cfgTxnUrl == null || cfgTxnUrl.isEmpty() || cfgClientId == null || cfgClientId.isEmpty() || cfgClientSecret == null || cfgClientSecret.isEmpty()) {
            logger.warning("setConfig: required config parameters NOT provided");
            return false;
        }
        if (cfgAuthUrl != uriAuth || cfgTxnUrl != uriTxn || cfgClientId != clientId || cfgClientSecret != clientSecret) {
            authToken.setValid(false);
        }
        if (cfgAuthUrl != uriAuth) {
            uriAuth = cfgAuthUrl;
        }
        if (cfgTxnUrl != uriTxn) {
            uriTxn = cfgTxnUrl;
        }
        if (cfgClientId != clientId) {
            clientId = cfgClientId;
        }
        if (cfgClientSecret != clientSecret) {
            clientSecret = cfgClientSecret;
        }
        if (cfgAuthUrl != uriAuth) {
            uriAuth = cfgAuthUrl;
        }
        this.uapMaxSize = newConfig.getMaxMessageSize();
        if (this.uapMaxSize <= 0 || this.uapMaxSize > defaultUapMaxSize) {
            logger.warning("Invalid config uapMaxSize=" + this.uapMaxSize + ", defaulted to " + defaultUapMaxSize);
            this.uapMaxSize = defaultUapMaxSize;
        }
        this.batchInterval = newConfig.getBatchInterval();
        if (this.batchInterval <= 0) {
            logger.warning("Invalid config batchInterval=" + this.batchInterval + ", defaulted to " + defaultBatchInterval);
            this.batchInterval = defaultBatchInterval;
        }
        this.queueSize = newConfig.getBatchSize();
        if (this.queueSize <= 0) {
            logger.warning("Invalid queue size=" + this.queueSize + ", defaulted to " + defaultQueueSize);
            this.queueSize = defaultQueueSize;
        }
        mq.setQsize(this.queueSize);
        this.maxQueues = newConfig.getMaxBatches();
        if (this.maxQueues <= 0) {
            logger.warning("Invalid max queues=" + this.maxQueues + ", defaulted to " + defaultMaxQueues);
            this.maxQueues = defaultMaxQueues;
        }
        mq.setMaxQueues(this.maxQueues);
        boolean cfgDisableServerCertValidation = newConfig.isServerCertValidationDisabled();
        if (this.serverCertValidationDisabled != cfgDisableServerCertValidation) {
            this.serverCertValidationDisabled = cfgDisableServerCertValidation;
            authToken.setValid(false);
            try {
                tokenClient = new CqHttpClient(this.serverCertValidationDisabled);
            }
            catch (Exception e) {
                logger.warning("Failed to create token http client" + e.getMessage());
            }
            try {
                txnClient = new CqHttpClient(this.serverCertValidationDisabled);
            }
            catch (Exception e) {
                logger.warning("Failed to create txn http client" + e.getMessage());
            }
        }
        if (newConfig.isValidAuthType()) {
            authType = newConfig.getAuthType();
        } else {
            logger.warning("Invalid Authentication type. defaulted to " + defaultAuthType);
            authType = defaultAuthType;
        }
        if (newConfig.isValidTxnEndpointType()) {
            txnEndpointType = newConfig.getTransactionEndpointType();
        } else {
            logger.warning("Invalid Transaction endpoint type. defaulted to " + defaultTxnEndpointType);
            txnEndpointType = defaultTxnEndpointType;
        }
        if (!authType.equals("oauth2")) {
            this.uapAuthDisabled = true;
        }
        if (!txnEndpointType.equals("uap")) {
            this.uapSendDisabled = true;
        }
        if (txnEndpointType.equals("log")) {
            this.logUapTxnEnabled = true;
        }
        libVersion = newConfig.getLibVersion();
        if (this.config == null) {
            this.config = new ConnectorConfig();
        }
        this.config.setSrcGwName(newConfig.getSrcGwName());
        this.config.setAuthTokenUrl(uriAuth);
        this.config.setTransactionEndpointUrl(uriTxn);
        this.config.setClientId(clientId);
        this.config.setClientSecret(clientSecret);
        this.config.setMaxMessageSize(this.uapMaxSize);
        this.config.setBatchSize(this.queueSize);
        this.config.setMaxBatches(this.maxQueues);
        this.config.setBatchInterval(this.batchInterval);
        this.config.setServerCertValidationDisabled(this.serverCertValidationDisabled);
        this.config.setAuthType(authType);
        this.config.setTransactionEndpointType(txnEndpointType);
        this.config.setLibVersion(libVersion);
        logger.info("setConfig: applied new config: " + this.config);
        return true;
    }

    public Boolean initialize(String pluginVersion) {
        ReturnCode tokenRetCode = ReturnCode.EXIT_SUCCESS;
        CequenceConnector.pluginVersion = pluginVersion;
        if (this.uapSendDisabled) {
            logger.warning("sending to UAP disabled & hence Auth is also disabled..");
            this.uapAuthDisabled = true;
        }
        if (!this.uapSendDisabled) {
            if (txnClient == null) {
                try {
                    txnClient = new CqHttpClient(this.serverCertValidationDisabled);
                }
                catch (Exception e) {
                    logger.warning("Failed to create txn http client; error: " + e.getMessage());
                }
            }
            if (!this.uapAuthDisabled && tokenClient == null) {
                try {
                    tokenClient = new CqHttpClient(this.serverCertValidationDisabled);
                }
                catch (Exception e) {
                    logger.warning("Failed to create token http client; error: " + e.getMessage());
                }
            }
        }
        if (!this.uapSendDisabled && !this.uapAuthDisabled) {
            try {
                tokenRetCode = this.tokenHandler();
            }
            catch (Exception e) {
                logger.warning("initialize: get token failed; error: " + e.getMessage());
                return false;
            }
            if (tokenRetCode == ReturnCode.EXIT_FAILURE) {
                logger.warning("initialize: Failed to get authentication token from url: " + uriAuth);
                return false;
            }
        }
        if (sTimer == null) {
            sTimer = TimerService.getInstance(logger);
            sTimer.start(this);
        }
        mq.setLogger(logger);
        connectorReady = true;
        return true;
    }

    public Boolean shutdown() {
        connectorReady = false;
        logger.info("shutting down in progress.. not accepting any new transactions..");
        logger.info("stopping the timer based transaction flush..");
        if (sTimer != null) {
            sTimer.stop();
        }
        int dropCount = 0;
        ArrayList<ApiTransaction> txn_list = mq.getQueue();
        while (txn_list != null) {
            dropCount += txn_list.size();
            txn_list.clear();
            txn_list = mq.getQueue();
        }
        if (dropCount > 0) {
            logger.warning("dropping pending transactions. count: " + dropCount);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorStats getStats() {
        ConnectorStats stats = new ConnectorStats();
        CequenceConnector cequenceConnector = this;
        synchronized (cequenceConnector) {
            stats.txnRx = txnRx;
            stats.txnTx = txnTx;
            stats.txnTxBatches = txnTxBatches;
            stats.txnAvgTxSize = txnAvgTxSize;
            stats.txnDiscarded = txnDiscarded;
            stats.txnItemsInQueue = mq.getQItemCount();
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean AddTransaction(ApiTransaction txn) {
        if (!connectorReady.booleanValue()) {
            logger.warning("AddTransaction: system is NOT in READY state");
            return false;
        }
        if (txn == null || !txn.isValid()) {
            logger.warning("AddTransaction: Invalid txn data");
            return false;
        }
        if (!(this.uapSendDisabled || this.uapAuthDisabled || authToken.isValid())) {
            logger.warning("AddTransaction: Don't have valid token. Not accepting the transaction data");
            return false;
        }
        String metaDataSrcVersion = txn.metadata.source.version;
        if (metaDataSrcVersion == null || metaDataSrcVersion.isEmpty()) {
            txn.metadata.source.version = metaDataSrcVersion = pluginVersion + "-" + this.config.getLibVersion();
            logger.info("AddTransaction: SouceInfo.version not provided.. Added: " + metaDataSrcVersion);
        } else if (!metaDataSrcVersion.endsWith("-" + this.config.getLibVersion())) {
            txn.metadata.source.version = metaDataSrcVersion = metaDataSrcVersion + "-" + this.config.getLibVersion();
            logger.info("AddTransaction: SouceInfo.version doesn't have the library version.. version updated to: " + metaDataSrcVersion);
        }
        if (txn.txnLatency == 0L) {
            long endTxnPopulateNano = System.nanoTime();
            long txnLatency = (endTxnPopulateNano - txn.txnCreateTime) / 1000L;
            txn.setTxnLatency(txnLatency);
            logger.info("AddTransaction: txn latency not provided.. set to (approx us): " + txnLatency);
        }
        MQAddRValue rv = mq.add(txn);
        CequenceConnector cequenceConnector = this;
        synchronized (cequenceConnector) {
            ++txnRx;
            if (rv.discarded) {
                txnDiscarded += (long)rv.dropCount;
            }
        }
        if (rv.discarded) {
            logger.warning("All queues full, discarded oldest " + String.valueOf(rv.dropCount) + " txns");
        }
        if (rv.readyToDrain) {
            this.queueHandler();
        }
        return true;
    }

    void sendBatch() {
        logger.finest("Timer fired, sendBatch");
        this.queueHandler();
    }

    void queueHandler() {
        ArrayList<ApiTransaction> cq_txn_list = mq.getQueue();
        if (cq_txn_list == null || cq_txn_list.size() == 0) {
            return;
        }
        int countTx = cq_txn_list.size();
        long avgTxnPopulateLatency = 0L;
        long sum = 0L;
        if (countTx > 0) {
            for (ApiTransaction txn : cq_txn_list) {
                sum += txn.getTxnLatency();
            }
            avgTxnPopulateLatency = sum / (long)countTx;
        }
        long avgQHandlerLatency = 0L;
        long startQHandlerNano = System.nanoTime();
        this.txnBatchProcess(cq_txn_list);
        long endQHandlerNano = System.nanoTime();
        int currBatchCount = cq_txn_list.size();
        cq_txn_list.clear();
        if (endQHandlerNano > startQHandlerNano && currBatchCount > 0) {
            avgQHandlerLatency = (endQHandlerNano - startQHandlerNano) / (long)currBatchCount;
            avgQHandlerLatency /= 1000L;
        }
        logger.info("checkRequest: cur-batch-size=" + Integer.toString(currBatchCount) + ", avg-txn-latency= " + avgTxnPopulateLatency + "us, avg-batch-processing-latency= " + avgQHandlerLatency + "us");
    }

    private void txnBatchProcess(List<ApiTransaction> recTxnsList) {
        try {
            this.txnBatchProcessingRecursive(recTxnsList, 0, recTxnsList.size() - 1);
        }
        catch (Exception e) {
            logger.warning("txnBatchProcess: exception " + e.getMessage());
        }
    }

    private void txnBatchProcessingRecursive(List<ApiTransaction> recTxnsList, int start, int end) throws Exception {
        String payload = this.serializeBatch(recTxnsList, start, end);
        logger.finer("txnBatchProcessingRecursive: Handling payload of length: " + payload.length());
        if (start == end && payload.length() > this.uapMaxSize) {
            logger.warning("Too big payload in single txn, not sending UAP, len:" + payload.length());
            return;
        }
        if (payload.length() <= this.uapMaxSize) {
            if (payload.length() > 0) {
                this.txnSend(payload, recTxnsList.size());
            }
        } else {
            payload = null;
            int mid = (end - start) / 2 + start;
            this.txnBatchProcessingRecursive(recTxnsList, start, mid);
            this.txnBatchProcessingRecursive(recTxnsList, mid + 1, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void txnSend(String payload, int countTx) throws Exception {
        if (this.logUapTxnEnabled) {
            logger.info("txnSend: writing to the log output.. count: " + countTx + " length: " + payload.length() + " payload: " + payload);
        }
        if (this.uapSendDisabled) {
            return;
        }
        ReturnCode authTokenStatus = ReturnCode.EXIT_SUCCESS;
        if (!this.uapAuthDisabled) {
            authTokenStatus = this.tokenHandler();
        }
        if (authTokenStatus == ReturnCode.EXIT_FAILURE) {
            logger.warning("txnSend: Failed to get token");
            return;
        }
        long payloadSize = payload.length();
        CequenceConnector cequenceConnector = this;
        synchronized (cequenceConnector) {
            txnAvgTxSize = (txnAvgTxSize * txnTx + payloadSize) / (txnTx + (long)countTx);
            txnTx += (long)countTx;
            ++txnTxBatches;
        }
        URL url = URI.create(uriTxn).toURL();
        RequestBody reqBody = RequestBody.create(MediaType.parse("application/json"), payload.getBytes());
        Request request = new Request.Builder().url(url).post(reqBody).header("Content-type", "application/json").header("Authorization", "Bearer " + authToken.getAccessToken()).build();
        try (Response response = CequenceConnector.txnClient.httpClient.newCall(request).execute();){
            if (response.code() != 200) {
                logger.warning("txnSend : response code=" + response.code() + " countTx:" + Integer.toString(countTx));
            } else {
                String responseBody = response.body().string();
                logger.finest("txnSend response : code=" + response.code() + " body=" + responseBody);
            }
        }
        catch (Exception e) {
            logger.warning("txnSend: Error while sending request. " + e.getMessage());
        }
        if (countTx > 0) {
            int avgTxnPayload = payload.length() / countTx;
            logger.info("txnSend Stats, avgTxnSize (this batch): " + avgTxnPayload + " avgTxnSize (so far):" + txnAvgTxSize + " Rx:" + txnRx + " Tx:" + txnTx);
        }
    }

    String serializeBatch(List<ApiTransaction> recTxnsList, int start, int end) throws Exception {
        HashMap<String, List<ApiTransaction>> apiTxnPayload = new HashMap<String, List<ApiTransaction>>();
        apiTxnPayload.put("data", recTxnsList.subList(start, end + 1));
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson(apiTxnPayload);
    }

    List<ApiTransaction> deSerializeBatch(String txnsStr) throws Exception {
        Type deserializeType = new TypeToken<Map<String, List<ApiTransaction>>>(){}.getType();
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        Map data = (Map)gson.fromJson(txnsStr, deserializeType);
        List txnsList = (List)data.get("data");
        return txnsList;
    }

    private ReturnCode tokenHandler() throws Exception {
        int expr = 0;
        if (authToken.getExpiresIn() != null) {
            expr = Integer.parseInt(authToken.getExpiresIn().toString());
        }
        long expireTimeInSeconds = this.getTokenCapturedTimeInSec + (long)((double)expr * 0.85);
        this.currGatewayTimeInSec = Instant.now().getEpochSecond();
        if (this.currGatewayTimeInSec >= expireTimeInSeconds) {
            authToken.setValid(false);
            logger.info("Token expired. Initiating token fetch");
        }
        if (!authToken.isValid()) {
            return this.getToken();
        }
        return ReturnCode.EXIT_SUCCESS;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private ReturnCode getToken() throws Exception {
        block21: {
            if (authToken.isValid()) {
                return ReturnCode.EXIT_SUCCESS;
            }
            HashMap<Object, Object> data = new HashMap<Object, Object>();
            data.put("client_id", clientId);
            data.put("client_secret", clientSecret);
            data.put("scope", "profile");
            data.put("grant_type", "client_credentials");
            URL url = URI.create(uriAuth).toURL();
            RequestBody reqBody = RequestBody.create(MediaType.parse("application/x-www-form-urlencoded"), CequenceConnector.buildPostDataFromMap(data));
            Request request = new Request.Builder().url(url).post(reqBody).header("Content-type", "application/x-www-form-urlencoded").build();
            try {
                Throwable throwable = null;
                try (Response response = CequenceConnector.tokenClient.httpClient.newCall(request).execute();){
                    if (response.code() != 200) {
                        logger.warning("getToken: Failed to get token, response code=" + response.code() + " token URI: " + uriAuth);
                        break block21;
                    }
                    String responseBody = response.body().string();
                    logger.finest("getToken response : code=" + response.code() + " body length=" + responseBody.length());
                    try {
                        JsonObject jo = new Gson().fromJson(responseBody, JsonObject.class);
                        authToken.setAccessToken(jo.get("access_token").getAsString());
                        authToken.setExpiresIn(jo.get("expires_in").getAsInt());
                        authToken.setRefreshExpiresIn(jo.get("refresh_expires_in").getAsInt());
                        authToken.setRefreshToken(jo.get("refresh_token").getAsString());
                        authToken.setTokenType(jo.get("token_type").getAsString());
                        authToken.setNotBeforePolicy(jo.get("not-before-policy").getAsInt());
                        authToken.setSessionState(jo.get("session_state").getAsString());
                        authToken.setScope(jo.get("scope").getAsString());
                        authToken.setValid(true);
                        logger.fine("Token retrieved successfully. Expires in " + jo.get("expires_in").getAsString() + " seconds");
                        this.getTokenCapturedTimeInSec = Instant.now().getEpochSecond();
                        ReturnCode returnCode = ReturnCode.EXIT_SUCCESS;
                        return returnCode;
                    }
                    catch (Exception e) {
                        try {
                            logger.warning("getToken: response code=" + response.code() + " body=" + response.body().string());
                            logger.warning("getToken: error=" + e.getMessage());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warning("getToken: Error while sending request. " + e.getMessage());
            }
        }
        return ReturnCode.EXIT_FAILURE;
    }

    private static String buildPostDataFromMap(Map<Object, Object> data) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : data.entrySet()) {
            if (builder.length() > 0) {
                builder.append("&");
            }
            try {
                builder.append(URLEncoder.encode(entry.getKey().toString(), StandardCharsets.UTF_8.name()));
                builder.append("=");
                builder.append(URLEncoder.encode(entry.getValue().toString(), StandardCharsets.UTF_8.name()));
            }
            catch (Exception e) {
                String k = entry.getKey().toString();
                logger.warning("buildPostDataFromMap: fail to encode for key: " + k + " error: " + e.getMessage());
            }
        }
        return builder.toString();
    }

    static {
        libVersion = defaultLibVersion = "1.1";
        authToken = new Token();
        txnClient = null;
        tokenClient = null;
        mq = new MultiQueue(defaultQueueSize, defaultMaxQueues, logger);
        sTimer = null;
    }

    public static enum ReturnCode {
        EXIT_SUCCESS,
        EXIT_FAILURE;

    }
}

