/*
 * Decompiled with CFR 0.152.
 */
package ai.cequence.integrations.edge.common;

import ai.cequence.integrations.edge.common.CequenceConnector;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class TimerService {
    private static TimerService instance = null;
    Logger logger;
    static MyTimerTask task = null;
    static Timer timer = null;
    long delayConst = 5000L;

    private TimerService(Logger theLogger) {
        this.logger = theLogger;
    }

    public static TimerService getInstance(Logger logger) {
        if (instance == null) {
            instance = new TimerService(logger);
            return instance;
        }
        if (task != null) {
            task.cancel();
            task = null;
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        return instance;
    }

    public void start(CequenceConnector connector) {
        if (connector != null) {
            try {
                task = new MyTimerTask(connector);
                timer = new Timer("Timer");
                timer.schedule((TimerTask)task, this.delayConst, (long)connector.batchInterval);
            }
            catch (Exception exception) {
                this.logger.warning("timer service already started. " + exception.getMessage());
            }
        } else {
            this.logger.warning("timer service not started, connector null");
        }
    }

    public void stop() {
        if (task != null) {
            task.cancel();
            task = null;
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    class MyTimerTask
    extends TimerTask {
        private CequenceConnector connectorT;

        MyTimerTask(CequenceConnector connector) {
            this.connectorT = connector;
        }

        @Override
        public void run() {
            this.connectorT.sendBatch();
        }
    }
}

