/*
 * Decompiled with CFR 0.152.
 */
package ai.cequence.integrations.edge.common;

import ai.cequence.integrations.edge.common.MQAddRValue;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiQueue<T> {
    private int maxQueues = 200;
    private int qsize = 100;
    private Logger logger;
    private Deque<ArrayList<T>> qlist = new LinkedList<ArrayList<T>>();
    private final Object queueLock = new Object();

    public MultiQueue(int qsize, int maxQs, Logger libLogger) {
        this.qsize = qsize;
        this.maxQueues = maxQs;
        this.logger = libLogger;
        ArrayList tlist = new ArrayList();
        this.qlist.add(tlist);
    }

    public void setLogger(Logger libLogger) {
        this.logger = libLogger;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    public void setQsize(int qsize) {
        this.qsize = qsize;
    }

    public int NumQueues() {
        return this.qlist.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQItemCount() {
        int itemCount = 0;
        Object object = this.queueLock;
        synchronized (object) {
            for (ArrayList<T> theQ : this.qlist) {
                itemCount += theQ.size();
            }
        }
        return itemCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MQAddRValue add(T elem) {
        MQAddRValue mqrv = new MQAddRValue(false, false);
        if (elem == null) {
            return mqrv;
        }
        Object object = this.queueLock;
        synchronized (object) {
            ArrayList<T> lq = this.qlist.peekLast();
            if (lq == null) {
                ArrayList<T> tlist = new ArrayList<T>();
                tlist.add(elem);
                this.qlist.add(tlist);
                return mqrv;
            }
            if (lq.size() < this.qsize) {
                lq.add(elem);
            } else if (this.qlist.size() < this.maxQueues) {
                ArrayList<T> tlist = new ArrayList<T>();
                tlist.add(elem);
                this.qlist.add(tlist);
                mqrv.readyToDrain = true;
            } else {
                block11: {
                    try {
                        ArrayList<T> tlist = this.qlist.pop();
                        mqrv.dropCount = tlist.size();
                        tlist.clear();
                        tlist.add(elem);
                        this.qlist.add(tlist);
                    }
                    catch (Exception e) {
                        this.logger.warning("MultiQueue.add: we are expecting queue are full but found no queues. " + e.getMessage());
                        if (mqrv.dropCount != 0) break block11;
                        mqrv.dropCount = 1;
                    }
                }
                mqrv.discarded = true;
            }
        }
        return mqrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<T> getQueue() {
        Object object = this.queueLock;
        synchronized (object) {
            try {
                return this.qlist.pop();
            }
            catch (Exception e) {
                this.logger.log(Level.FINER, "MultiQueue.getQueue: no queues. " + e.getMessage());
            }
        }
        return null;
    }
}

