/*
 * Decompiled with CFR 0.152.
 */
package com.cequence.logging;

import ai.cequence.integrations.edge.common.ApiTransaction;
import ai.cequence.integrations.edge.common.Body;
import ai.cequence.integrations.edge.common.CequenceConnector;
import ai.cequence.integrations.edge.common.Connection;
import ai.cequence.integrations.edge.common.ConnectorConfig;
import ai.cequence.integrations.edge.common.Metadata;
import ai.cequence.integrations.edge.common.Request;
import ai.cequence.integrations.edge.common.Response;
import ai.cequence.integrations.edge.common.SourceInfo;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.rest.AbstractHandler;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.joda.time.DateTime;
import org.wso2.carbon.utils.CarbonUtils;

public class LoggingApplication
extends AbstractHandler {
    public static final String[] WHITELIST_CONTENT_TYPES = new String[]{"application/json", "application/json; charset=utf-8", "application/xml", "application/soap+xml", "text/xml", "text/plain", "application/x-www-form-urlencoded"};
    private static final Log log = LogFactory.getLog(LoggingApplication.class);
    private static final String PROPERTIES_PATH = "/repository/conf/cequence.properties";
    private static final String LOG_TRANSACTION_ENDPOINT_TYPE = "log";
    private static final String AUTH_TYPE_NONE = "none";
    ExecutorService executorService;
    String propertiesFilename;
    private String authEndpointUrl;
    String transactionEndpointUrl;
    String clientId;
    String clientSecret;
    private static final String TRANSACTION_DURATION_HANDLE_REQUEST = "transaction.duration.handle.request";
    private static final String TRANSACTION_DURATION_LATENCY = "total.duration.latency";
    private static final String VERSION = "2.6.0";
    private static final String SOURCE_TYPE = "wso2-apim-2.6.0";
    private static final String REQUEST_VERSION = "1.1";
    private static final String CEQUENCE_CONNECTOR_VERSION = "1.1";
    ConnectorConfig connectorConfig;
    CequenceConnector cequenceConnector;
    Logger logger;
    boolean shouldSentToRemote = true;
    private String commonLibLogLevel = "INFO";
    String transactionEndpointType;

    public LoggingApplication() {
        int nThreads = Runtime.getRuntime().availableProcessors();
        this.executorService = Executors.newFixedThreadPool(nThreads);
        this.logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.getConfigProperties();
        this.connectorConfig = new ConnectorConfig();
        this.connectorConfig.setAuthTokenUrl(this.authEndpointUrl);
        this.connectorConfig.setTransactionEndpointUrl(this.transactionEndpointUrl);
        this.connectorConfig.setClientId(this.clientId);
        this.connectorConfig.setClientSecret(this.clientSecret);
        this.connectorConfig.setServerCertValidationDisabled(true);
        if (LOG_TRANSACTION_ENDPOINT_TYPE.equalsIgnoreCase(this.transactionEndpointType)) {
            this.connectorConfig.setTransactionEndpointType(LOG_TRANSACTION_ENDPOINT_TYPE);
            this.connectorConfig.setAuthType(AUTH_TYPE_NONE);
        }
        this.cequenceConnector = CequenceConnector.getInstance((ConnectorConfig)this.connectorConfig, (Logger)this.logger);
        this.cequenceConnector.initialize("1.1");
    }

    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        long startTime = System.nanoTime();
        this.executorService.submit(() -> this.requestHandler(messageContext));
        long endTime = System.nanoTime();
        long durationNanos = endTime - startTime;
        log.info((Object)("[[handleRequest]] REQUEST Duration " + durationNanos + " microseconds"));
        messageContext.setProperty(TRANSACTION_DURATION_HANDLE_REQUEST, (Object)durationNanos);
        return true;
    }

    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        long startTime = System.nanoTime();
        log.debug((Object)("Started Handle Response: " + new DateTime()));
        this.executorService.submit(() -> this.responseHandler(messageContext));
        long endTime = System.nanoTime();
        log.debug((Object)("Completed Handle Response: " + new DateTime()));
        Long requestDuration = (Long)messageContext.getProperty(TRANSACTION_DURATION_HANDLE_REQUEST);
        if (requestDuration != null) {
            long durationNanos = endTime - startTime;
            log.debug((Object)("[[handleResponse]] RESPONSE Duration " + durationNanos + " nanoseconds"));
            long totalDuration = requestDuration + durationNanos;
            messageContext.setProperty(TRANSACTION_DURATION_LATENCY, (Object)totalDuration);
            log.debug((Object)("[[handleResponse]] Total Duration " + totalDuration + " nanoseconds"));
        }
        return true;
    }

    private boolean requestHandler(org.apache.synapse.MessageContext messageContext) {
        String serverIp;
        log.debug((Object)("[[requestHandler()]] Started in a separate thread: " + new DateTime()));
        String apiName = (String)messageContext.getProperty("SYNAPSE_REST_API");
        String messageId = messageContext.getMessageID().replace("urn:uuid:", "");
        messageId = messageId.replace("urn:uuid:", "");
        log.debug((Object)("REQUEST MESSAGE ID: " + messageId));
        String httpResource = (String)messageContext.getProperty("REST_FULL_REQUEST_PATH");
        MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        String httpMethod = (String)axis2MessageContext.getProperty("HTTP_METHOD");
        Map requestHeaders = (Map)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        String mapAsString = this.convertWithStream(requestHeaders);
        log.debug((Object)("[[requestHandler()]] Request Headers:: " + mapAsString));
        String sourceIP = this.extractRemoteIp(axis2MessageContext);
        log.debug((Object)("[[requestHandler() data processing]] INCOMING client IP::  " + sourceIP));
        String sslProtocol = (String)axis2MessageContext.getProperty("axis2-sslprotocol");
        String httpScheme = sslProtocol != null && sslProtocol.toLowerCase().startsWith("https") ? "https" : "http";
        String httpHost = (String)requestHeaders.get("Host");
        String httpVersion = (String)requestHeaders.get("{version}");
        if (httpHost.contains(":")) {
            httpHost = httpHost.split(":")[0];
        }
        String queryFragment = (String)axis2MessageContext.getProperty("TransportInURL");
        log.debug((Object)("[[requestHandler() data processing]] Query Fragment: " + queryFragment));
        String connectionIp = this.extractConnectionIp(axis2MessageContext);
        if (connectionIp == null || connectionIp.isEmpty()) {
            connectionIp = sourceIP;
        }
        String requestMessage = "";
        int requestMessageLength = 0;
        try {
            RelayUtils.buildMessage((MessageContext)axis2MessageContext);
            requestMessage = JsonUtil.jsonPayloadToString((MessageContext)axis2MessageContext);
            requestMessageLength = requestMessage.getBytes(StandardCharsets.UTF_8).length;
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        log.debug((Object)("[[requestHandler() data processing]] INCOMING Request message: " + requestMessage));
        try {
            serverIp = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            serverIp = "";
        }
        try {
            messageContext.setProperty("apiNameRequest", (Object)apiName);
            messageContext.setProperty("requestMessage", (Object)requestMessage);
            messageContext.setProperty("messageIdRequest", (Object)messageId);
            messageContext.setProperty("httpResourceRequest", (Object)httpResource);
            messageContext.setProperty("requestHost", (Object)httpHost);
            messageContext.setProperty("sourceIP", (Object)sourceIP);
            messageContext.setProperty("httpScheme", (Object)httpScheme);
            messageContext.setProperty("httpVersion", (Object)httpVersion);
            messageContext.setProperty("httpMethodRequest", (Object)httpMethod);
            messageContext.setProperty("queryFragment", (Object)queryFragment);
            messageContext.setProperty("requestMessageLength", (Object)requestMessageLength);
            messageContext.setProperty("connectionIpRequest", (Object)connectionIp);
            messageContext.setProperty("ceqRequestHeaders", (Object)mapAsString);
            messageContext.setProperty("serverIp", (Object)serverIp);
            messageContext.setProperty("connectionIp", (Object)connectionIp);
            log.debug((Object)"[[requestHandler()]] I AM IN THE CORRECT PATH ");
            return true;
        }
        catch (Exception e) {
            log.info((Object)("[[requestHandler()]] I AM IN THE FAIL PATH " + e.getMessage()));
            e.printStackTrace();
            log.debug((Object)("Completed requestHandler() in a separate thread: " + new DateTime()));
            return false;
        }
    }

    private String extractRemoteIp(MessageContext axis2MessageContext) {
        Map headersMap;
        String xForwardedFor;
        Pattern PRIVATE_IP_PATTERN = Pattern.compile("^(?:10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|172\\.(?:1[6-9]|2\\d|3[0-1])\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})$");
        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (headers != null && headers instanceof Map && (xForwardedFor = (String)(headersMap = (Map)headers).get("X-Forwarded-For")) != null) {
            for (String ip : xForwardedFor.split(",")) {
                if (PRIVATE_IP_PATTERN.matcher(ip = ip.trim()).matches()) continue;
                return ip;
            }
        }
        String remoteAddr = (String)axis2MessageContext.getProperty("REMOTE_ADDR");
        return remoteAddr;
    }

    private String extractConnectionIp(MessageContext axis2MessageContext) {
        Map headersMap;
        String xForwardedFor;
        Object headers;
        String remoteAddr = (String)axis2MessageContext.getProperty("REMOTE_ADDR");
        Pattern PRIVATE_IP_PATTERN = Pattern.compile("^(?:10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|172\\.(?:1[6-9]|2\\d|3[0-1])\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})$");
        if (remoteAddr == null && (headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS")) != null && headers instanceof Map && (xForwardedFor = (String)(headersMap = (Map)headers).get("X-Forwarded-For")) != null) {
            for (String ip : xForwardedFor.split(",")) {
                if (PRIVATE_IP_PATTERN.matcher(ip = ip.trim()).matches()) continue;
                return ip;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean responseHandler(org.apache.synapse.MessageContext messageContext) {
        Map responseHeaders;
        String contentType;
        log.debug((Object)("Started responseHandler() in a separate thread: " + new DateTime()));
        String responseMessage = "";
        String messageId = messageContext.getMessageID().replace("urn:uuid:", "");
        MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        try {
            RelayUtils.buildMessage((MessageContext)((Axis2MessageContext)messageContext).getAxis2MessageContext());
            responseMessage = JsonUtil.jsonPayloadToString((MessageContext)((Axis2MessageContext)messageContext).getAxis2MessageContext());
        }
        catch (Exception e) {
            log.info((Object)("Response body is null" + e.getMessage()));
            responseMessage = "";
        }
        log.debug((Object)("[[responseHandler()]] Response Message: " + responseMessage));
        String requestHeadersString = (String)messageContext.getProperty("ceqRequestHeaders");
        log.debug((Object)("[[responseHandler()]] Request Headers in response" + requestHeadersString));
        Map<String, String> requestHeaders = null;
        if (requestHeadersString != null && (contentType = (requestHeaders = this.convertWithStream(requestHeadersString)).get("Content-Type")) != null) {
            contentType = this.normalizeContentType(contentType);
            this.shouldSentToRemote = Arrays.stream(WHITELIST_CONTENT_TYPES).anyMatch(contentType::equalsIgnoreCase);
            log.debug((Object)("[[shouldSentToRemote]]" + this.shouldSentToRemote));
            if (!this.shouldSentToRemote) {
                return false;
            }
        }
        try {
            responseHeaders = (Map)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        }
        catch (Exception ex) {
            responseHeaders = null;
            ex.printStackTrace();
            log.info((Object)"[[axis2MessageContext.getProperty(TRANSPORT_HEADERS)]] failed to process responseHeaders");
        }
        log.debug((Object)"[[axis2MessageContext.getProperty(TRANSPORT_HEADERS)]] successfully processed responseHeaders");
        ArrayList<String> concatenatedRequestHeaders = new ArrayList<String>();
        if (requestHeaders != null) {
            int index = 0;
            try {
                ConcurrentHashMap<String, String> threadSafeRequestHeaders;
                Map<String, String> map = requestHeaders;
                synchronized (map) {
                    threadSafeRequestHeaders = new ConcurrentHashMap<String, String>(requestHeaders);
                }
                this.generateBase64Headers(concatenatedRequestHeaders, index, threadSafeRequestHeaders);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info((Object)("[[responseHandler() - generateBase64Headers]] failed to process base64Headers " + e.getMessage()));
            }
        }
        try {
            long unixEpochMillis = System.currentTimeMillis();
            Object latencyObj = messageContext.getProperty(TRANSACTION_DURATION_LATENCY);
            long transactionLatency = 0L;
            if (latencyObj != null) {
                transactionLatency = (Long)latencyObj;
            }
            ApiTransaction apiTransaction = new ApiTransaction();
            apiTransaction.setTransactionId(messageId);
            apiTransaction.setVersion("1.1");
            apiTransaction.setTimestamp(String.valueOf(unixEpochMillis));
            apiTransaction.setTxnLatency(transactionLatency);
            SourceInfo source = new SourceInfo();
            String sourceIp = (String)messageContext.getProperty("sourceIP");
            source.setInstanceId(sourceIp);
            source.setPoolId("apim1");
            source.setVersion("2.6.0-" + this.connectorConfig.getLibVersion());
            source.setType(SOURCE_TYPE);
            Metadata metadata = new Metadata();
            metadata.setSource(source);
            apiTransaction.setMetadata(metadata);
            Request request = new Request();
            request.setClientIp(sourceIp);
            request.setScheme((String)messageContext.getProperty("httpScheme"));
            request.setVersion("1.1");
            String httpMethod = (String)messageContext.getProperty("httpMethodRequest");
            request.setMethod(httpMethod);
            String queryFragment = messageContext.getProperty("queryFragment") != null ? (String)messageContext.getProperty("queryFragment") : "";
            request.setUriQuery(queryFragment);
            String requestHost = (String)messageContext.getProperty("requestHost");
            if (requestHost != null) {
                request.setUriHost(requestHost.split(":")[0]);
            } else {
                request.setUriHost("");
            }
            String connectionIp = messageContext.getProperty("connectionIpRequest") != null ? (String)messageContext.getProperty("connectionIpRequest") : "";
            String serverIp = messageContext.getProperty("serverIp") != null ? (String)messageContext.getProperty("serverIp") : "";
            Connection connection = new Connection(connectionIp, serverIp);
            connection.setTransactionDepth((short)1);
            request.setConnection(connection);
            request.setHeaders(concatenatedRequestHeaders);
            Body requestBody = new Body();
            String requestMessage = (String)messageContext.getProperty("requestMessage");
            if (requestMessage != null && !requestMessage.isEmpty()) {
                requestBody.setData(Base64.getEncoder().encodeToString(requestMessage.getBytes()));
            } else {
                requestBody.setData("");
            }
            try {
                requestBody.setLength(Integer.parseInt(String.valueOf(messageContext.getProperty("requestMessageLength"))));
            }
            catch (NumberFormatException npe) {
                log.info((Object)"Failed to parse request message length - Request Body is null");
                requestBody.setLength(0);
            }
            request.setBody(requestBody);
            apiTransaction.setRequest(request);
            Response response = new Response();
            Body responseBody = new Body();
            responseBody.setData(Base64.getEncoder().encodeToString(responseMessage.getBytes()));
            int responseMessageLength = 0;
            try {
                responseMessageLength = responseMessage.getBytes(StandardCharsets.UTF_8).length;
            }
            catch (NumberFormatException npe) {
                log.info((Object)"Failed to parse response message length - Response Body is null");
            }
            responseBody.setLength(responseMessageLength);
            response.setBody(responseBody);
            String statusCode = String.valueOf((Integer)axis2MessageContext.getProperty("HTTP_SC"));
            response.setBody(responseBody);
            response.setStatusCode(statusCode);
            ExecutorService executorService = Executors.newFixedThreadPool(1);
            Map finalResponseHeaders = responseHeaders;
            executorService.submit(() -> this.prepareToSendToApi(apiTransaction, response, finalResponseHeaders));
            executorService.shutdown();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info((Object)("I AM IN THE FAIL PATH " + e.getMessage()));
            log.debug((Object)("Completed responseHandler() in a separate thread: " + new DateTime()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareToSendToApi(ApiTransaction apiTransaction, Response response, Map<String, String> ceqResponseHeaders) {
        ArrayList<String> concatenatedResponseHeaders = new ArrayList<String>();
        int index = 0;
        try {
            Map<String, String> map = ceqResponseHeaders;
            synchronized (map) {
                ConcurrentHashMap<String, String> threadSafeResponseHeaders = new ConcurrentHashMap<String, String>(ceqResponseHeaders);
                this.generateBase64Headers(concatenatedResponseHeaders, index, threadSafeResponseHeaders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        response.setHeaders(concatenatedResponseHeaders);
        apiTransaction.setResponse(response);
        this.sendApiTransactions(apiTransaction);
        return true;
    }

    private List<String> generateBase64Headers(List<String> concatenatedResponseHeaders, int index, ConcurrentHashMap<String, String> threadSafeResponseHeaders) {
        for (Map.Entry<String, String> entry : threadSafeResponseHeaders.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().equals("null")) {
                String concatenatedHeader = entry.getKey() + " : " + Base64.getEncoder().encodeToString(entry.getValue().getBytes());
                concatenatedResponseHeaders.add(concatenatedHeader);
            }
            ++index;
        }
        this.shouldSentToRemote = true;
        return concatenatedResponseHeaders;
    }

    private void sendApiTransactions(ApiTransaction apiTransaction) {
        if (this.shouldSentToRemote) {
            boolean responseStatus = this.cequenceConnector.AddTransaction(apiTransaction);
            log.debug((Object)("[[sendApiTransactions -- AddTransaction]] Response Status --> " + responseStatus));
        } else {
            log.info((Object)"[[sendApiTransactions]] Invalid Content type: Not sending to remote");
        }
    }

    private void getConfigProperties() {
        String carbonHome = CarbonUtils.getCarbonHome();
        log.debug((Object)("CARBON HOME:: " + carbonHome));
        this.propertiesFilename = carbonHome + PROPERTIES_PATH;
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(this.propertiesFilename);
            this.authEndpointUrl = (String)config.getProperty("authEndpointUrl");
            this.transactionEndpointUrl = (String)config.getProperty("transactionEndpointUrl");
            this.clientId = (String)config.getProperty("clientId");
            this.clientSecret = (String)config.getProperty("clientSecret");
            this.commonLibLogLevel = (String)config.getProperty("commonLibLogLevel");
            this.transactionEndpointType = (String)config.getProperty("transactionEndpointType");
            this.setCommonLibLevel(this.commonLibLogLevel);
            log.debug((Object)("[[getConfigProperties]] - authEndpointUrl" + this.authEndpointUrl));
            log.debug((Object)("[[getConfigProperties]] - transactionEndpointUrl" + this.transactionEndpointUrl));
            log.debug((Object)("[[getConfigProperties - clientId]] " + this.clientId));
            log.debug((Object)("[[getConfigProperties - clientSecret]] " + this.clientSecret));
            log.debug((Object)("[[getConfigProperties - transactionEndpointType]] " + this.transactionEndpointType));
            log.debug((Object)("[[getConfigProperties - commonLibLogLevel]] " + this.commonLibLogLevel));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void setCommonLibLevel(String commonLibLogLevel) {
        if (commonLibLogLevel != null) {
            switch (commonLibLogLevel) {
                case "DEBUG": {
                    this.logger.setLevel(Level.FINE);
                    break;
                }
                case "WARN": {
                    this.logger.setLevel(Level.WARNING);
                    break;
                }
                case "ERROR": {
                    this.logger.setLevel(Level.SEVERE);
                    break;
                }
                default: {
                    this.logger.setLevel(Level.INFO);
                }
            }
        }
    }

    public String convertWithStream(Map<String, String> map) {
        String mapAsString = map.keySet().stream().map(key -> key + "=" + (String)map.get(key)).collect(Collectors.joining("::", "{", "}"));
        return mapAsString;
    }

    public Map<String, String> convertWithStream(String mapAsString) {
        mapAsString = mapAsString.replaceAll("[{}]", "");
        return Arrays.stream(mapAsString.split("::")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0].trim(), entry -> entry[1].trim()));
    }

    public String normalizeContentType(String contentType) {
        return contentType.split(";")[0].trim();
    }
}

